package gov.va.med.mhv.researchhealth.web.controller;

import java.io.Serializable;
import java.util.Calendar;
import java.util.GregorianCalendar;

import javax.faces.bean.ManagedBean;
import javax.faces.bean.ViewScoped;
import javax.faces.context.FacesContext;
import javax.portlet.PortletRequest;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.WebKeys;
import com.liferay.portal.kernel.workflow.WorkflowConstants;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalArticleDisplay;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journalcontent.util.JournalContentUtil;


/**
 * This is to control and determine what tip of the day will be displayed in the
 * Tip Of The Day Portlet.
 * 
 * @author Michael Hussey
 * @version 1.0 07-21-2015.
 */

@ManagedBean (name="tipOfDayController")
@ViewScoped
public class TipOfDayController implements Serializable {

	private static final long serialVersionUID = 566655676015313L;

	private static Logger log = LogManager.getLogger(TipOfDayController.class);
	private Integer days=1;
	private String content;
	
	
	public TipOfDayController() {
		GregorianCalendar gc = new GregorianCalendar();
		setDays(gc.get(GregorianCalendar.DAY_OF_YEAR));
	}

	public void findArticleId() {
		log.debug("Finding content for day" + getDays());
		JournalArticle article = null;
		try {	
			// The database expects a lowercase name
			PortletRequest portletRequest = (PortletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();        
			ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute(WebKeys.THEME_DISPLAY);
			article = JournalArticleLocalServiceUtil.getLatestArticleByUrlTitle(
					themeDisplay.getScopeGroupId(), "tip" + getDays(),WorkflowConstants.STATUS_APPROVED);
			
			if(article!=null) {
				setContent(getWebContent(String.valueOf(article.getPrimaryKey())));
			}
			} catch (PortalException e) {
			log.error("Failed to get Tip Of The Day. Article doesn't exist", e);
			setContent("Content in CMS Does Not Exist");		
		} catch (SystemException e) {
			log.error("Failed to get Tip Of The Day. Article doesn't exist", e);
			setContent("Content in CMS Does Not Exist");		
		}
	
		
		
	}
	
	/**
	 * Gets Previous Day's Tip of The Day prevDay()
	 * 
	 * @return Tip Of The Day for Prev Day
	 */

	public String prevDay() {
		setDays(getDays() - 1);
		findArticleId();
		return null;
	}

	
	/**
	 * Gets Today's Tip of The Day toDay()
	 * 
	 * @return Tip Of The Day for Today
	 * 
	 */
	public String toDay() {
		setDays(GregorianCalendar.getInstance().get(Calendar.DAY_OF_YEAR));	
		findArticleId();
		return null;
	}

	/**
	 * Gets Next Day's Tip of The Day nextDay()
	 * 
	 * @return Tip Of The Day for Next Day
	 */

	public String nextDay() {
		setDays(getDays() + 1);	
		findArticleId();
		return null;
	}

	/**
	 * Gets Days getDays()
	 * 
	 * @return Days
	 */

	public int getDays() {
		return this.days;
	}

	/**
	 * Sets Days setDays(int days)
	 * 
	 * @param int days
	 * @return Days
	 */

	public void setDays(int days) {
		//We need to check for 367 because there are 366 tips
		//Checking for 366 will give a 0 and there is no tip 0
		if (days==0) {
			this.days=366;
		}
		else if(days % 367 == 0) {
			this.days=1;
		}
		else {
			this.days = days % 367;
		}

	}

	/**
	 * @return the content
	 */
	public String getContent() {
		if (content == null) {
			toDay();
		}
		return content;
		
	}

	/**
	 * @param content the content to set
	 */
	public void setContent(String content) {
		this.content = content;
	}

	
	/**
	 * This method displays web content created through the liferay web content portlet.
	 * @param id
	 * @return
	 */
	public String getWebContent(String id) {
		FacesContext context = FacesContext.getCurrentInstance();
		ThemeDisplay themeDisplay = (ThemeDisplay) context.getExternalContext().getRequestMap().get(WebKeys.THEME_DISPLAY);
		try {
			long groupId = themeDisplay.getScopeGroupId();
			Long articleId = new Long(id);
			JournalArticle article = JournalArticleLocalServiceUtil.getArticle(articleId);
			String languageKey = context.getExternalContext().getRequestLocale().toString();
			JournalArticleDisplay articleDisplay = JournalContentUtil.getDisplay(groupId, article.getArticleId(), article.getTemplateId(), languageKey, themeDisplay);
			return articleDisplay.getContent();
		} catch( Exception e) {
			e.printStackTrace();
			return e.getMessage();
		}
	}
}
